<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>File Transfer</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Font Awesome CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Public Sans', sans-serif;
            font-size: 14px;
        }
        h4 {
            font-size: 18px;
            font-family: 'Public Sans', sans-serif;
        }
        h5 {
            font-size: 16px;
            font-family: 'Public Sans', sans-serif;
        }
        .side-menu {
            width: 80px;
            background-color: #f8f9fa; /* White background */
            position: fixed;
            height: 100%;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: space-between;
            padding-top: 20px;
            z-index: 1000; /* Ensure the side menu is on top */
        }
        .side-menu .nav-link {
            color: #000;
            margin: 10px 0;
        }
        .side-menu .nav-link:hover {
            background-color: #e2e6ea;
            border-radius: 50%;
        }
        .side-menu .navbar-brand-box {
            text-align: center;
        }
        .side-menu .navbar-brand-box img {
            height: 30px;
        }
        .tab-pane-container {
            margin-left: 80px; /* Same as sidebar width */
            padding: 20px;
            width: 27%; /* Width of tabpane */
            float: left;
            height: 100vh;
            background-color: #F5F7FB; /* Background color for tab pane */
            overflow-y: auto;
        }
        .chat-search-box .form-control {
            border: none;
        }
        .chat-user-img {
            position: relative;
        }
        .chat-user-img .user-status {
            position: absolute;
            bottom: 0;
            right: 0;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background-color: #28a745; /* Online status color */
            border: 1px solid #fff;
        }
        .conversation-container {
            margin-left: 27%; /* Adjust based on tabpane width */
            padding: 20px;
            height: 100vh;
            overflow-y: auto;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }
        .conversation-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .conversation-list li {
            display: flex;
            margin-bottom: 10px;
        }
        .conversation-list .right {
            flex-direction: row-reverse;
        }
        .chat-avatar {
            width: 40px;
            height: 40px;
            margin-right: 10px;
        }
        .chat-avatar img {
            width: 100%;
            border-radius: 50%;
        }
        .user-chat-content {
            max-width: 75%;
        }
        .ctext-wrap {
            padding: 10px;
            border-radius: 10px;
            background-color: #f1f1f1;
            position: relative;
        }
        .ctext-wrap-content {
            padding: 5px 10px;
        }
        .chat-time {
            font-size: 12px;
            color: #888;
        }
        .conversation-name {
            font-size: 12px;
            color: #888;
            text-align: right;
        }
        .file-transfer-block {
            padding: 10px;
            border-top: 1px solid #eaeaea;
            background-color: #f8f9fa;
        }
        .file-transfer-block form {
            width: 100%;
        }
        .file-transfer-block .form-control {
            border: none;
            border-radius: 20px;
        }

        /* Responsive styles for mobile layout */
        @media (max-width: 768px) {
            .side-menu {
                width: 100%;
                height: 60px;
                flex-direction: row;
                padding-top: 0;
                justify-content: center;
                position: fixed;
                bottom: 0;
                z-index: 1000; /* Ensure the bottom bar is on top */
            }
            .side-menu .nav-link {
                margin: 0 10px;
            }
            .tab-pane-container {
                margin-left: 0;
                width: 100%;
                float: none;
                height: calc(100vh - 60px); /* Adjust for bottom bar */
                padding: 10px;
                padding-bottom: 70px; /* Additional padding to avoid content getting blocked by the bottom bar */
                box-sizing: border-box; /* Ensure padding is included in the element's total width and height */
            }
            .conversation-container {
                margin-left: 0;
                padding: 10px;
                width: 100%;
                display: none;
                height: calc(100vh - 60px); /* Adjust for bottom bar */
            }
            .conversation-container.active {
                display: flex;
            }
        }
    </style>
</head>
<body>
    <?php include 'includes/sidebar.php'; ?>
    <?php include 'includes/tabpane.php'; ?>
    <?php include 'includes/conversation.php'; ?>

    <!-- Main content -->
    <div class="content" style="margin-left: 80px;">
        <!-- Page content goes here -->
    </div>

    <!-- Bootstrap JS and dependencies -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        // JavaScript to handle mobile view interaction
        document.querySelectorAll('.chat-user-click').forEach(item => {
            item.addEventListener('click', event => {
                document.querySelector('.conversation-container').classList.add('active');
                document.querySelector('.tab-pane-container').style.display = 'none';
            });
        });

        // Optionally, add a back button to conversation view for mobile to go back to tab pane
        const backButton = document.createElement('button');
        backButton.textContent = 'Back';
        backButton.className = 'btn btn-link';
        backButton.style.position = 'absolute';
        backButton.style.top = '10px';
        backButton.style.left = '10px';
        backButton.addEventListener('click', () => {
            document.querySelector('.conversation-container').classList.remove('active');
            document.querySelector('.tab-pane-container').style.display = 'block';
        });
        document.querySelector('.conversation-container').appendChild(backButton);

        // JavaScript for Tab Switching
        document.querySelectorAll('.nav-link').forEach(item => {
            item.addEventListener('click', event => {
                event.preventDefault();
                const tabId = item.id.split('-')[0];
                document.querySelectorAll('.nav-link').forEach(link => link.classList.remove('active'));
                item.classList.add('active');
                
                if (tabId === 'chat') {
                    document.getElementById('chat-tab-content').style.display = 'block';
                    document.getElementById('profile-tab-content').style.display = 'none';
                    document.getElementById('groups-tab-content').style.display = 'none';
                    document.getElementById('contacts-tab-content').style.display = 'none';
                    document.getElementById('settings-tab-content').style.display = 'none';
                } else if (tabId === 'profile') {
                    document.getElementById('chat-tab-content').style.display = 'none';
                    document.getElementById('profile-tab-content').style.display = 'block';
                    document.getElementById('groups-tab-content').style.display = 'none';
                    document.getElementById('contacts-tab-content').style.display = 'none';
                    document.getElementById('settings-tab-content').style.display = 'none';
                } else if (tabId === 'groups') {
                    document.getElementById('chat-tab-content').style.display = 'none';
                    document.getElementById('profile-tab-content').style.display = 'none';
                    document.getElementById('groups-tab-content').style.display = 'block';
                    document.getElementById('contacts-tab-content').style.display = 'none';
                    document.getElementById('settings-tab-content').style.display = 'none';
                } else if (tabId === 'contacts') {
                    document.getElementById('chat-tab-content').style.display = 'none';
                    document.getElementById('profile-tab-content').style.display = 'none';
                    document.getElementById('groups-tab-content').style.display = 'none';
                    document.getElementById('contacts-tab-content').style.display = 'block';
                    document.getElementById('settings-tab-content').style.display = 'none';
                } else if (tabId === 'settings') {
                    document.getElementById('chat-tab-content').style.display = 'none';
                    document.getElementById('profile-tab-content').style.display = 'none';
                    document.getElementById('groups-tab-content').style.display = 'none';
                    document.getElementById('contacts-tab-content').style.display = 'none';
                    document.getElementById('settings-tab-content').style.display = 'block';
                }
            });
        });
    </script>
</body>
</html>
 