<?php
session_start();

// Database connection
$servername = "localhost";
$username = "kahnvis_type";
$password = "kahnvis_type";
$dbname = "kahnvis_type";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$response = ['status' => 'error', 'message' => 'Something went wrong'];

if (isset($_SESSION['user_id'])) {
    $current_user_id = $_SESSION['user_id'];

    // Fetch individual conversations
    $individual_conversations = $conn->query("
        SELECT u.id, u.name, u.avatar, 'individual' as type, (
            SELECT c.message
            FROM conversations c
            WHERE (c.from_user_id = '$current_user_id' AND c.to_user_id = u.id)
               OR (c.from_user_id = u.id AND c.to_user_id = '$current_user_id')
            ORDER BY c.created_at DESC
            LIMIT 1
        ) AS recent_message, (
            SELECT c.created_at
            FROM conversations c
            WHERE (c.from_user_id = '$current_user_id' AND c.to_user_id = u.id)
               OR (c.from_user_id = u.id AND c.to_user_id = '$current_user_id')
            ORDER BY c.created_at DESC
            LIMIT 1
        ) AS time
        FROM users u
        JOIN conversations c ON (u.id = c.from_user_id OR u.id = c.to_user_id)
        WHERE (c.from_user_id = '$current_user_id' OR c.to_user_id = '$current_user_id')
        GROUP BY u.id
    ");

    // Fetch group conversations
    $group_conversations = $conn->query("
        SELECT g.id, g.group_name AS name, g.avatar, 'group' as type, (
            SELECT c.message
            FROM conversations c
            WHERE c.group_id = g.id
            ORDER BY c.created_at DESC
            LIMIT 1
        ) AS recent_message, (
            SELECT c.created_at
            FROM conversations c
            WHERE c.group_id = g.id
            ORDER BY c.created_at DESC
            LIMIT 1
        ) AS time
        FROM groups g
        JOIN group_users gu ON g.id = gu.group_id
        WHERE gu.user_id = '$current_user_id'
        GROUP BY g.id
    ");

    $conversations = [];

    if ($individual_conversations->num_rows > 0) {
        while ($row = $individual_conversations->fetch_assoc()) {
            $conversations[] = $row;
        }
    }

    if ($group_conversations->num_rows > 0) {
        while ($row = $group_conversations->fetch_assoc()) {
            $conversations[] = $row;
        }
    }

    // Sort by time (newest first)
    usort($conversations, function ($a, $b) {
        return strtotime($b['time']) - strtotime($a['time']);
    });

    $response = ['status' => 'success', 'conversations' => $conversations];
}

$conn->close();
echo json_encode($response);
?>
