<!-- conversation.php -->
<div class="conversation-container">
    <div class="px-4 pt-4">
        <h4 class="mb-4">Conversation</h4>
    </div>

    <div class="conversation-list-container" data-simplebar>
        <ul class="conversation-list">
            <!-- Example static message -->
            <li class="left">
                <div class="conversation-list">
                    <div class="chat-avatar">
                        <img src="assets/images/user-avatar.jpg" alt="" class="imgavatar">
                    </div>

                    <div class="user-chat-content">
                        <div class="ctext-wrap">
                            <div class="ctext-wrap-content">
                                <p class="mb-0">Hello! How are you?</p>
                                <p class="chat-time mb-0">
                                    <i class="ri-time-line align-middle"></i> 
                                    <span class="align-middle">04 Aug 24, 09:45 AM</span>
                                </p>
                            </div>
                        </div>
                        <div class="conversation-name">User Name</div>
                    </div>
                </div>
            </li>
            <!-- Repeat for other messages -->
        </ul>
    </div>

   <!-- File transfer block -->
<!-- conversation.php -->
<div class="file-transfer-block">
    <form class="d-flex align-items-center">
        <button class="btn btn-link text-decoration-none" type="button" onclick="document.getElementById('fileInput').click();">
            <i class="fas fa-paperclip fa-lg" style="color: #007bff;"></i>
            <input type="file" id="fileInput" style="display: none;">
        </button>
        <input type="text" class="form-control bg-light ml-2" placeholder="Enter file description">
        <button class="btn btn-link text-decoration-none ml-2" type="submit">
            <i class="fas fa-paper-plane fa-lg" style="color: #007bff;"></i>
        </button>
    </form>
</div>

</div>

<script>
    document.getElementById('file-upload-button').addEventListener('click', function() {
        document.getElementById('file-input').click();
    });

    document.getElementById('file-upload-form').addEventListener('submit', function(event) {
        event.preventDefault();

        var formData = new FormData(this);
        fetch('upload_file.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                alert('File uploaded successfully');
                // Optionally, you can update the conversation list here
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while uploading the file.');
        });
    });
</script>


<script>
document.addEventListener('DOMContentLoaded', function () {
    const contactsTabContent = document.getElementById('contacts-tab-content');
    const chatTabContent = document.getElementById('chat-tab-content');
    const fileSelectButton = document.getElementById('file-select-button');
    const fileInput = document.getElementById('file-input');
    const fileUploadForm = document.getElementById('file-upload-form');
    const fileUploadButton = document.getElementById('file-upload-button');
    const progressContainer = document.getElementById('progress-container');
    const progressCircle = document.getElementById('progress-circle');
    const progressPercentage = document.getElementById('progress-percentage');
    let selectedUserId = null;

    function switchToChatTab() {
        contactsTabContent.style.display = 'none';
        chatTabContent.style.display = 'block';
    }

    document.querySelectorAll('.contact-item').forEach(item => {
        item.addEventListener('click', function () {
            document.querySelectorAll('.chat-message-item').forEach(chatItem => {
                chatItem.classList.remove('active');
            });

            const contactId = this.dataset.contactId;
            selectedUserId = contactId;

            fetch('open_conversation.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: `contact_id=${encodeURIComponent(contactId)}`
            })
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        const conversationList = document.querySelector('.conversation-list');
                        conversationList.innerHTML = ''; // Clear existing messages

                        if (data.messages.length > 0) {
                            data.messages.forEach(message => {
                                const messageItem = document.createElement('li');
                                messageItem.className = message.from_user_id === selectedUserId ? 'left' : 'right';
                                messageItem.innerHTML = `
                                    <div class="conversation-list">
                                        <div class="chat-avatar">
                                            <img src="${message.avatar}" alt="" class="imgavatar">
                                        </div>
                                        <div class="user-chat-content">
                                            <div class="ctext-wrap">
                                                <div class="ctext-wrap-content">
                                                    <p class="mb-0">${message.message}</p>
                                                    <p class="chat-time mb-0">
                                                        <i class="ri-time-line align-middle"></i> 
                                                        <span class="align-middle">${message.created_at}</span>
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="conversation-name">${message.name}</div>
                                        </div>
                                    </div>
                                `;
                                conversationList.appendChild(messageItem);
                            });
                        } else {
                            const startLabel = document.createElement('div');
                            startLabel.className = 'start-conversation-label';
                            startLabel.innerText = `Start of conversation with ${data.user_name} ${new Date().toLocaleDateString()} ${new Date().toLocaleTimeString()}`;
                            conversationList.appendChild(startLabel);
                        }

                        switchToChatTab();

                        // Mark the selected contact as active in the chat list
                        const chatMessageItem = document.createElement('a');
                        chatMessageItem.className = 'chat-message-item active';
                        chatMessageItem.innerHTML = `
                            <div class="d-flex align-items-start">
                                <div class="chat-user-img align-self-center mr-3">
                                    <img src="${data.user_avatar}" class="rounded-circle" alt="user-avatar" style="height: 2.9rem; width: 2.9rem;">
                                </div>
                                <div class="overflow-hidden">
                                    <h5 class="text-truncate font-size-14 mb-1">${data.user_name}</h5>
                                                                        <p class="text-truncate mb-0">Start a conversation</p>
                                </div>
                                <div class="font-size-12 ml-auto">
                                    <p class="mb-0">${new Date().toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' })}</p>
                                </div>
                            </div>
                        `;

                        const chatMessageList = document.querySelector('.chat-message-chatlist');
                        chatMessageList.prepend(chatMessageItem);

                        // Add click event to the new chat message item to switch to active state
                        chatMessageItem.addEventListener('click', function () {
                            document.querySelectorAll('.chat-message-item').forEach(chatItem => {
                                chatItem.classList.remove('active');
                            });
                            this.classList.add('active');
                        });

                        // Also, make the new chat message item active
                        chatMessageItem.classList.add('active');
                    } else {
                        alert('Error: ' + data.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error: Something went wrong');
                });
        });
    });

    fileSelectButton.addEventListener('click', function () {
        fileInput.click();
    });

    fileUploadForm.addEventListener('submit', function (event) {
        event.preventDefault();

        const file = fileInput.files[0];
        const description = document.getElementById('file-description').value.trim();

        if (!file || !description) {
            alert('Please select a file and enter a description.');
            return;
        }

        if (!selectedUserId) {
            alert('Error: Invalid session or request.');
            return;
        }

        const formData = new FormData();
        formData.append('file', file);
        formData.append('description', description);
        formData.append('contact_id', selectedUserId);

        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'upload_file.php', true);

        xhr.upload.addEventListener('progress', function (e) {
            if (e.lengthComputable) {
                const percentComplete = Math.round((e.loaded / e.total) * 100);
                progressContainer.style.display = 'block';
                progressPercentage.innerText = `${percentComplete}%`;
                progressCircle.style.strokeDashoffset = 440 - (440 * percentComplete) / 100;
            }
        });

        xhr.onload = function () {
            if (xhr.status === 200) {
                const response = JSON.parse(xhr.responseText);
                if (response.status === 'success') {
                    alert('File sent successfully!');
                    fileInput.value = '';
                    document.getElementById('file-description').value = '';
                    progressContainer.style.display = 'none';
                    fileUploadButton.style.display = 'inline';
                    progressCircle.style.strokeDashoffset = 440;
                } else {
                    alert('Error: ' + response.message);
                }
            } else {
                alert('Error: Something went wrong.');
            }
        };

        xhr.onerror = function () {
            alert('Error: Something went wrong.');
        };

        xhr.send(formData);

        fileUploadButton.style.display = 'none';
        progressContainer.style.display = 'block';
    });
});




</script>

